function meritoffset = meritoffsetcalc(allspots,varfit)
% This function calculates the merit function offset for an accurate
% determination of the log-likelihood.

% (C) Copyright 2018
% All rights reserved
% Department of Imaging Physics
% Faculty of Applied Sciences
% Delft University of Technology
% Delft, The Netherlands   

Ncfg = size(allspots,3);
meritoffset = zeros(Ncfg,1);
for jcfg = 1:Ncfg 
  dummat = allspots(:,:,jcfg);
  [Nxpixels Nypixels] = size(dummat);
  
  % set negative and zero pixels values to one/10 to avoid log-singularity
  dummat = max(dummat,ones(size(dummat))/10);
    
  
  meritoffset(jcfg) = 0;
  for ii=1:Nxpixels
    for jj = 1:Nypixels
        meritoffset(jcfg) = meritoffset(jcfg)-gammln(dummat(ii,jj)+1+varfit);
    end
  end
     
end